/************************************************************************************
* This file is owned by the platform/application specific software and basically 
* defines how the 802.15.4 FreeScale MAC is configured. The file is included by the
* relevant MAC modules and is necessary for the MAC to compile.
*
* Author(s): Knud Dyring-Olsen, Jesper Thomsen
*
* (c) Copyright 2005, Freescale, Inc.  All rights reserved.
*
* Freescale Confidential Proprietary
* Digianswer Confidential
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale.
*
* Last Inspected:
* Last Tested:
************************************************************************************
*	10/13/06 - For TYPE_FFD the system clock was changed from 75 to 50
*
*
************************************************************************************/

#ifndef _HPRFGW_RFAPPTOPLATFORMCONFIG_H_
#define _HPRFGW_RFAPPTOPLATFORMCONFIG_H_

//**********************************************************************************
// Define one Hardware platform type (if not defined default is TARGET_AXIOM_GB60):
//**********************************************************************************
 
// Enable target platform
//#define TARGET_DIG528_2 // 13192-EVB
//#define TARGET_DIG536_2 // 13192-SARD
//#define TARGET_DIG534_1 // Sniffer
//#define TARGET_AXIOM_GB60 // 802.15.4 Dev Platform
//#define TARGET_RD01 // For all boards which uses the Freescale reference design 01 layout
#define TARGET_M5271EVB

//**********************************************************************************
// Set default target hardware platform if none selected:
//**********************************************************************************
#if !(defined(TARGET_DIG528_2) || defined(TARGET_DIG536_2) || defined(TARGET_DIG534_1) || defined(TARGET_AXIOM_GB60) || defined(TARGET_RD01) || defined(TARGET_M523xEVB) || defined(TARGET_M5271EVB))
//#define TARGET_DIG528_2 // 13192-EVB
//#define TARGET_DIG536_2 // 13192-SARD
//#define TARGET_DIG534_1 // Sniffer
//#define TARGET_AXIOM_GB60 // 802.15.4 Dev Platform
//#define TARGET_RD01 // For all boards which uses the Freescale reference design 01 layout
#define TARGET_M5271EVB
#endif

////////////////////////////////////////
/// Define "PHY Type" (length 7 char) //
////////////////////////////////////////
#if defined TARGET_AXIOM_GB60
  #define PHY_TYPE "AX-0308"
#elif defined TARGET_DIG528_2
  #define PHY_TYPE " DIG528"
#elif defined TARGET_DIG536_2
  #define PHY_TYPE " DIG536"
#elif defined TARGET_RD01
  #define PHY_TYPE " RD01  "
#elif defined TARGET_DIG534_1
  #define PHY_TYPE " DIG534"
#elif defined TARGET_M5271EVB
  #define PHY_TYPE " 5271EVB"
#else
  #error No target defined!!!
#endif


//**********************************************************************************
// PTC application defines
//**********************************************************************************
#ifdef INCLUDE_802_15_4 // Defined by NWK build environment
 #define F8W_NWK_PRESENT 1 // Define if compiling for F8W target - excludes PTC PHY fnc-table init.
#else
 //#define F8W_NWK_PRESENT 1
#endif INCLUDE_802_15_4



//**********************************************************************************
// Select platform clock speed selection depending on MAC device type 
// MAC device type minimum clock values. User can specify a higher clock frequency.
// If none selected default to 16MHz
// Valid values for SYSTEM_CLOCK: 8, 12, 16, 16780

#ifdef Type_RFDNBNS
	#define SYSTEM_CLOCK 75
#endif Type_RFDNBNS

#ifdef Type_RFDNBNV
	#define SYSTEM_CLOCK 75
#endif Type_RFDNBNV

#ifdef  Type_RFDNB
	#define SYSTEM_CLOCK 75
#endif  Type_RFDNB

#ifdef Type_RFD
	#define SYSTEM_CLOCK 75
#endif Type_RFD

#ifdef Type_FFDNBNS
	#define SYSTEM_CLOCK 75
#endif Type_FFDNBNS

#ifdef Type_FFDNBNV
	#define SYSTEM_CLOCK 75
#endif Type_FFDNBNV

#ifdef Type_FFDNB
	#define SYSTEM_CLOCK 75
#endif Type_FFDNB

#ifdef Type_FFDNGTS
	#define SYSTEM_CLOCK 75
#endif Type_FFDNGTS

#ifdef Type_FFD
	#define SYSTEM_CLOCK 50	
#endif Type_FFD

// If device type is not predefined use the following definitions:
#ifndef SYSTEM_CLOCK 
  #define SYSTEM_CLOCK 75
#endif /* SYSTEM_CLOCK */

//**********************************************************************************


#endif /* _APPTOPLATFORMCONFIG_H_ */
